/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.animation;

import org.eclipse.swt.SWT;


public class PropertyAnimation extends Animation {
	long duration;
	Object target, from, to;
	String property;


void create() {
	if (target == null || property == null) SWT.error(SWT.ERROR_INVALID_ARGUMENT);
	_create();
}
native void _create() /*-{
	var animateProperties = null;
	
	var to = this.@org.eclipse.swt.animation.PropertyAnimation::to;
	var from = this.@org.eclipse.swt.animation.PropertyAnimation::from;
	var property =  this.@org.eclipse.swt.animation.PropertyAnimation::property;

	
	if (property == "size" || property == "location") {
		var property1 = null;
		var property2 = null;
		if (from != null) {
		 property1 = {start: from.@org.eclipse.swt.graphics.Point::x,
		 		  end: to.@org.eclipse.swt.graphics.Point::x,
		 		  unit:"px"
		 		 };
		 property2 = {start: from.@org.eclipse.swt.graphics.Point::y,
		 		   end: to.@org.eclipse.swt.graphics.Point::y,
		 		   unit:"px"
		 		 };
		} else {
			//TODO: If start not specified, get the current widget's coordinated to use as start point
			property1 = { end: to.@org.eclipse.swt.graphics.Point::x,
			 		  unit:"px"
			 		 };
			 property2 = {end: to.@org.eclipse.swt.graphics.Point::y,
			 		   unit:"px"
			 		 };
		}
		if (property == "size") {
			animateProperties = {
				  	width: property1,
				  	height: property2,
				  };
		} else {
			animateProperties = {
				  	x: property1,
				  	y: property2,
				  };
		}
	} else if (property == "bounds") {
		var propertyX = null;
		var propertyY = null;
		var propertyWidth = null;
		var propertyHeight = null;
		
		if (from != null) {
		animateProperties = {
			x: {start: from.@org.eclipse.swt.graphics.Rectangle::x,
		 		  end: to.@org.eclipse.swt.graphics.Rectangle::x,
		 		  unit:"px"
		 		 },
		 	y: {start: from.@org.eclipse.swt.graphics.Rectangle::y,
		 		   end: to.@org.eclipse.swt.graphics.Rectangle::y,
		 		   unit:"px"
		 		 },
		 	width: {start: from.@org.eclipse.swt.graphics.Rectangle::width,
		 		   end: to.@org.eclipse.swt.graphics.Rectangle::width,
		 		   unit:"px"
		 		 },
		 	height: {start: from.@org.eclipse.swt.graphics.Rectangle::height,
		 		   end: to.@org.eclipse.swt.graphics.Rectangle::height,
		 		   unit:"px"
		 		 }
		 };
		} else {
			//TODO: If start not specified, get the current widget's coordinated to use as start point
			animateProperties = {
				x:  {end: to.@org.eclipse.swt.graphics.Rectangle::x,
	 		  			unit:"px"
	 		 			},
			 y: {end: to.@org.eclipse.swt.graphics.Rectangle::y,
			 		   	  unit:"px"
			 		 	  },
			 width: { end: to.@org.eclipse.swt.graphics.Rectangle::width,
			 		 			unit:"px"
			 		 			},
			 height: {end: to.@org.eclipse.swt.graphics.Rectangle::height,
			 		   			unit:"px"
			 		 		   }
			 };
		}
	} else if (property == "x") {
		if (from != null) {
			 animateProperties = {x: {start: from.@java.lang.Number::intValue(),
			 		  				 end: to.@java.lang.Number::intValue(),
			 		  				unit:"px"}
		 		 };
		 } else {
			 animateProperties = {x: {
			 		  				 end: to.@java.lang.Number::intValue(),
			 		  				unit:"px"}
			 		 };
		 }
	} else if (property == "y") {
		if (from != null) {
			 animateProperties = {y: {start: from.@java.lang.Number::intValue(),
			 		  				 end: to.@java.lang.Number::intValue(),
			 		  				unit:"px"}
		 		 };
		 } else {
			 animateProperties = {y: {
			 		  				 end: to.@java.lang.Number::intValue(),
			 		  				unit:"px"}
			 		 };
		 }
	} else if (property == "width") {
		if (from != null) {
			 animateProperties = {width: {start: from.@java.lang.Number::intValue(),
			 		  				 end: to.@java.lang.Number::intValue(),
			 		  				unit:"px"}
		 		 };
		 } else {
			 animateProperties = {width: {
			 		  				 end: to.@java.lang.Number::intValue(),
			 		  				unit:"px"}
			 		 };
		 }
	} else if (property == "height") {
			if (from != null) {
			 animateProperties = {height: {start: from.@java.lang.Number::intValue(),
			 		  				 end: to.@java.lang.Number::intValue(),
			 		  				unit:"px"}
		 		 };
		 } else {
			 animateProperties = {height: {
			 		  				 end: to.@java.lang.Number::intValue(),
			 		  				unit:"px"}
			 		 };
		 }
	} else {
		throw "PropertyAnimation: " + property + " not supported."
	}
	
	
	var target = this.@org.eclipse.swt.animation.PropertyAnimation::target;
	this.@org.eclipse.swt.animation.Animation::jsObject = $wnd.dojo.animateProperty(
		{ node: target.@org.eclipse.swt.widgets.Widget::jsObject.domNode,
		  duration: this.@org.eclipse.swt.animation.PropertyAnimation::duration,
		  repeat: this.@org.eclipse.swt.animation.Animation::repeatCount,
		  delay: this.@org.eclipse.swt.animation.Animation::startDelay,
		  properties: animateProperties,
		  onAnimate: function() {target.@org.eclipse.swt.widgets.Control::sendResize()();}
		}
	);
	
}-*/;


public long getDuration() {
	checkAnimation ();
	return duration;
}

public void setDuration(long duration) {
	checkAnimation ();
	this.duration = duration;
}

public void setFrom(Object value) {
	checkAnimation ();
	from = value;
}

public void setProperty(String property) {
	checkAnimation ();
	this.property = property;
}

public void setTarget(Object target) {
	checkAnimation ();
	this.target = target;
}

public void setTo(Object value) {
	checkAnimation ();
	to = value;
}

}

